/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.validator;

import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.demos.bean.DemosInstallSettings;
import oracle.install.ivw.demos.resource.DemosErrorCode;
import oracle.install.library.util.CompatibilityMatrix;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.StageSizeInfo;

public class InstallLocationValidator
extends BaseInstallLocationValidator {
    public void validate(FlowContext flowContext) throws ValidationException {
        super.validate(flowContext);
        StatusMessages errorMessages = super.getValidationStatusMessages();
        InstallSettings installSettings = (InstallSettings)flowContext.getBean(DemosInstallSettings.class);
        String oraHome = installSettings.getOracleHome();
        String oraBase = installSettings.getOracleBase();
        if (oraBase == null || oraBase.length() == 0 || oraHome == null || oraHome.length() == 0) {
            return;
        }
        errorMessages.addAll(this.validateForNonDBHome(oraHome));
        boolean considerOracleHomeOffset = false;
        try {
            long requiredSize = StageSizeInfo.getSize((String)"DB", (boolean)considerOracleHomeOffset);
            if (GenericValidation.validateForFreeSpace((long)requiredSize, (String)installSettings.getOracleHome()) < 0L) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{requiredSize}));
            }
        }
        catch (InstallException e) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage(e.getErrorCode(), new Object[0]));
        }
    }

    public InstallSettings getInstallSettings(FlowContext flowContext) {
        InstallSettings installSettings = (InstallSettings)flowContext.getBean(DemosInstallSettings.class);
        return installSettings;
    }

    public StatusMessages<ValidationStatusMessage> validateForNonDBHome(String homeLoc) {
        StatusMessages errorMessages = new StatusMessages();
        InventoryInfo inventory = InventoryInfo.getInstance();
        boolean compatible = true;
        try {
            if (!CompatibilityMatrix.getInstance().isCompatibleHome(homeLoc, "NONE")) {
                compatible = false;
            }
        }
        catch (Exception e) {
            compatible = false;
        }
        if (!compatible) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DemosErrorCode.INSTALL_DEMOS_NON_DB_ORACLE_HOME, new Object[]{homeLoc}));
        }
        return errorMessages;
    }
}

